/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 O*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00050\u0004:\u0002OPB\u0015\u0012\f\u0010L\u001a\b\u0012\u0004\u0012\u00020K0\u0006\u00a2\u0006\u0004\bM\u0010NJ)\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u00060\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJC\u0010\u001f\u001a\u00028\u000022\u0010\u001e\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u00070\u001b\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u0007H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J#\u0010\u001f\u001a\u00028\u00002\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010\"J\u0017\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020#H&\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010&\u001a\u00020%2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b&\u0010*J\u0019\u0010-\u001a\u00028\u00002\b\b\u0002\u0010,\u001a\u00020+H&\u00a2\u0006\u0004\b-\u0010.R\"\u0010/\u001a\u00020+8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R(\u0010\u0012\u001a\u0004\u0018\u00010\u00102\b\u00105\u001a\u0004\u0018\u00010\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0012\u00106\u001a\u0004\b7\u00108R.\u0010\u0019\u001a\u0004\u0018\u00010\u00102\b\u00105\u001a\u0004\u0018\u00010\u00108\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u00106\u001a\u0004\b9\u00108\"\u0004\b:\u0010;R$\u0010\u0018\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00178\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0018\u0010<\u001a\u0004\b=\u0010>RP\u0010?\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u00070\u00062\u001c\u00105\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u00070\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010\u000bR\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0014\u0010H\u001a\u00020E8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0014\u0010)\u001a\u00020(8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006Q"}, d2={"Lorg/jetbrains/exposed/sql/AbstractQuery;", "T", "Lorg/jetbrains/exposed/sql/SizedIterable;", "Lorg/jetbrains/exposed/sql/ResultRow;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "arguments", "()Ljava/util/List;", "other", "", "copyTo", "(Lorg/jetbrains/exposed/sql/AbstractQuery;)V", "", "n", "fetchSize", "(I)Lorg/jetbrains/exposed/sql/AbstractQuery;", "", "iterator", "()Ljava/util/Iterator;", "", "offset", "limit", "(IJ)Lorg/jetbrains/exposed/sql/AbstractQuery;", "", "Lorg/jetbrains/exposed/sql/Expression;", "Lorg/jetbrains/exposed/sql/SortOrder;", "order", "orderBy", "([Lkotlin/Pair;)Lorg/jetbrains/exposed/sql/AbstractQuery;", "column", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/SortOrder;)Lorg/jetbrains/exposed/sql/AbstractQuery;", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "builder", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "", "value", "withDistinct", "(Z)Lorg/jetbrains/exposed/sql/AbstractQuery;", "count", "Z", "getCount", "()Z", "setCount", "(Z)V", "<set-?>", "Ljava/lang/Integer;", "getFetchSize", "()Ljava/lang/Integer;", "getLimit", "setLimit", "(Ljava/lang/Integer;)V", "J", "getOffset", "()J", "orderByExpressions", "Ljava/util/List;", "getOrderByExpressions", "getQueryToExecute", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "queryToExecute", "Lorg/jetbrains/exposed/sql/FieldSet;", "getSet", "()Lorg/jetbrains/exposed/sql/FieldSet;", "set", "getTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/Table;", "targets", "<init>", "(Ljava/util/List;)V", "Companion", "ResultIterator", "exposed-core"})
public abstract class AbstractQuery<T extends AbstractQuery<T>>
extends Statement<ResultSet>
implements SizedIterable<ResultRow> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends Pair<? extends Expression<?>, ? extends SortOrder>> orderByExpressions;
    @Nullable
    private Integer limit;
    private long offset;
    @Nullable
    private Integer fetchSize;
    private boolean count;

    public AbstractQuery(@NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        super(StatementType.SELECT, targets);
        this.orderByExpressions = new ArrayList();
    }

    @NotNull
    protected final Transaction getTransaction() {
        return TransactionManager.Companion.current();
    }

    @NotNull
    public final List<Pair<Expression<?>, SortOrder>> getOrderByExpressions() {
        return this.orderByExpressions;
    }

    @Nullable
    public final Integer getLimit() {
        return this.limit;
    }

    protected final void setLimit(@Nullable Integer n) {
        this.limit = n;
    }

    public final long getOffset() {
        return this.offset;
    }

    @Nullable
    public final Integer getFetchSize() {
        return this.fetchSize;
    }

    @NotNull
    public abstract FieldSet getSet();

    protected final void copyTo(@NotNull AbstractQuery<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        other.orderByExpressions = CollectionsKt.toMutableList((Collection)this.orderByExpressions);
        other.limit = this.limit;
        other.offset = this.offset;
        other.fetchSize = this.fetchSize;
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        return this.prepareSQL(new QueryBuilder(true));
    }

    @NotNull
    public abstract String prepareSQL(@NotNull QueryBuilder var1);

    @NotNull
    public List<List<Pair<IColumnType, Object>>> arguments() {
        QueryBuilder it = new QueryBuilder(true);
        boolean bl = false;
        this.prepareSQL(it);
        return !((Collection)it.getArgs()).isEmpty() ? CollectionsKt.listOf(it.getArgs()) : CollectionsKt.emptyList();
    }

    @NotNull
    public abstract T withDistinct(boolean var1);

    public static /* synthetic */ AbstractQuery withDistinct$default(AbstractQuery abstractQuery, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withDistinct");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return abstractQuery.withDistinct(bl);
    }

    @NotNull
    public T limit(int n, long offset) {
        AbstractQuery abstractQuery;
        AbstractQuery $this$limit_u24lambda_u2d1 = abstractQuery = this;
        boolean bl = false;
        $this$limit_u24lambda_u2d1.setLimit(n);
        $this$limit_u24lambda_u2d1.offset = offset;
        return (T)abstractQuery;
    }

    @NotNull
    public final T orderBy(@NotNull Expression<?> column, @NotNull SortOrder order) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        Pair[] pairArray = new Pair[]{TuplesKt.to(column, (Object)((Object)order))};
        return (T)this.orderBy(pairArray);
    }

    public static /* synthetic */ AbstractQuery orderBy$default(AbstractQuery abstractQuery, Expression expression, SortOrder sortOrder, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: orderBy");
        }
        if ((n & 2) != 0) {
            sortOrder = SortOrder.ASC;
        }
        return abstractQuery.orderBy(expression, sortOrder);
    }

    @NotNull
    public T orderBy(Pair<? extends Expression<?>, ? extends SortOrder> ... order) {
        AbstractQuery abstractQuery;
        Intrinsics.checkNotNullParameter(order, (String)"order");
        AbstractQuery $this$orderBy_u24lambda_u2d2 = abstractQuery = this;
        boolean bl = false;
        CollectionsKt.addAll((Collection)TypeIntrinsics.asMutableList($this$orderBy_u24lambda_u2d2.getOrderByExpressions()), (Object[])order);
        return (T)abstractQuery;
    }

    @NotNull
    public final T fetchSize(int n) {
        AbstractQuery abstractQuery;
        AbstractQuery $this$fetchSize_u24lambda_u2d3 = abstractQuery = this;
        boolean bl = false;
        $this$fetchSize_u24lambda_u2d3.fetchSize = n;
        return (T)abstractQuery;
    }

    protected final boolean getCount() {
        return this.count;
    }

    protected final void setCount(boolean bl) {
        this.count = bl;
    }

    @NotNull
    protected abstract Statement<ResultSet> getQueryToExecute();

    @Override
    @NotNull
    public Iterator<ResultRow> iterator() {
        ResultSet resultSet = this.getTransaction().exec(this.getQueryToExecute());
        Intrinsics.checkNotNull((Object)resultSet);
        ResultIterator resultIterator = new ResultIterator(resultSet);
        return this.getTransaction().getDb().getSupportsMultipleResultSets() ? (Iterator)resultIterator : CollectionsKt.toList((Iterable)new Iterable<ResultRow>(resultIterator){
            final /* synthetic */ ResultIterator $resultIterator$inlined;
            {
                this.$resultIterator$inlined = resultIterator;
            }

            @NotNull
            public Iterator<ResultRow> iterator() {
                boolean bl = false;
                return this.$resultIterator$inlined;
            }
        }).iterator();
    }

    @Override
    @NotNull
    public SizedIterable<ResultRow> forUpdate() {
        return SizedIterable.DefaultImpls.forUpdate(this);
    }

    @Override
    @NotNull
    public SizedIterable<ResultRow> notForUpdate() {
        return SizedIterable.DefaultImpls.notForUpdate(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0004\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R$\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00038\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/sql/AbstractQuery$ResultIterator;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "", "hasNext", "()Z", "next", "()Lorg/jetbrains/exposed/sql/ResultRow;", "", "Lorg/jetbrains/exposed/sql/Expression;", "", "fieldsIndex", "Ljava/util/Map;", "value", "Z", "setHasNext", "(Z)V", "Ljava/sql/ResultSet;", "rs", "Ljava/sql/ResultSet;", "getRs", "()Ljava/sql/ResultSet;", "<init>", "(Lorg/jetbrains/exposed/sql/AbstractQuery;Ljava/sql/ResultSet;)V", "exposed-core"})
    private final class ResultIterator
    implements Iterator<ResultRow>,
    KMappedMarker {
        @NotNull
        private final ResultSet rs;
        private boolean hasNext;
        @NotNull
        private final Map<Expression<?>, Integer> fieldsIndex;

        /*
         * WARNING - void declaration
         */
        public ResultIterator(ResultSet rs) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Intrinsics.checkNotNullParameter((Object)AbstractQuery.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            this.rs = rs;
            Iterable iterable = CollectionsKt.toSet((Iterable)AbstractQuery.this.getSet().getRealFields());
            ResultIterator resultIterator = this;
            boolean $i$f$mapIndexed = false;
            void var5_6 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void expression;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Expression expression2 = (Expression)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)expression, (Object)((int)index)));
            }
            resultIterator.fieldsIndex = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            this.setHasNext(this.rs.next());
            if (this.hasNext) {
                Companion.trackResultSet(AbstractQuery.this.getTransaction());
            }
        }

        @NotNull
        public final ResultSet getRs() {
            return this.rs;
        }

        private final void setHasNext(boolean value2) {
            this.hasNext = value2;
            if (!this.hasNext) {
                java.sql.Statement statement = this.rs.getStatement();
                if (statement != null) {
                    statement.close();
                }
                Transaction transaction2 = AbstractQuery.this.getTransaction();
                int n = transaction2.getOpenResultSetsCount$exposed_core();
                transaction2.setOpenResultSetsCount$exposed_core(n + -1);
            }
        }

        @Override
        @NotNull
        public ResultRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            ResultRow result2 = ResultRow.Companion.create(this.rs, this.fieldsIndex);
            this.setHasNext(this.rs.next());
            return result2;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/AbstractQuery$Companion;", "", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "trackResultSet", "(Lorg/jetbrains/exposed/sql/Transaction;)V", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void trackResultSet(Transaction transaction2) {
            int threshold = transaction2.getDb().getConfig().getLogTooMuchResultSetsThreshold();
            if (threshold > 0 && threshold < transaction2.getOpenResultSetsCount$exposed_core()) {
                String message = "Current opened result sets size " + transaction2.getOpenResultSetsCount$exposed_core() + " exceeds " + threshold + " threshold for transaction " + transaction2.getId() + ' ';
                String stackTrace = ExceptionsKt.stackTraceToString((Throwable)new Exception(message));
                SQLLogKt.getExposedLogger().error(stackTrace);
            }
            int n = transaction2.getOpenResultSetsCount$exposed_core();
            transaction2.setOpenResultSetsCount$exposed_core(n + 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

